* International Extension - What Caused the U.S Pandemic-Era Inflation? Bernanke, Blanchard 2023 
* This version : April 16, 2024
* Please contact Dilek Sevinc (dsevinc@piie.com) for further questions. 

* 1-year inflation expectation regression for the 10 economies (excl. Japan  due to confidentiality issues) 
* USA, ECB, BOE, (JPN), FRA, GER, ITA, ESP, BEL, NLD, CAN

global basePath1 ".../Replication Package/(1) Data"
global basePath2 ".../Replication Package/(3) Regression Results"

***************************************************************************************************
* one year inflation expectation, precovid sample
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


*** USA, ECB, BOE, FRA, ITA, GER, ESP, BEL, NLD, CAN // see also seperate do file for GER

local teams "USA ECB BOE FRA GER ITA ESP BEL NLD CAN"
local startperiod_USA 1989:1
local startperiod_ECB 1989:1
local startperiod_BOE 1990:1
local startperiod_FRA 1989:1
local startperiod_GER 1996:1
local startperiod_ITA 1999:2
local startperiod_ESP 1995:1
local startperiod_BEL 1996:1
local startperiod_NLD 1989:1
local startperiod_CAN 1994:1

foreach c of local teams{
	
constraint define 3  l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' + cf10_`c' + l1.cf10_`c' + l2.cf10_`c' + l3.cf10_`c' + l4.cf10_`c' + gcpi_`c' + l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' = 1

cnsreg cf1_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4)), c(3) noconstant

eststo col3
predict cf1f_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4))
gen cf1_residuals_`c' = cf1_`c'-cf1f_`c'

* Save coefficients in excel format 
putexcel set "(3) cf1_eq_coeff", modify sheet("cf1_`c'")
putexcel B1 = "beta_precovid"
putexcel B1 = "beta_precovid"
matrix b = e(b)'
putexcel A2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(3) cf1_summary_stats", modify sheet("cf1_`c'")
putexcel B1 = "sum of coefficients_precovid"
putexcel B1 = "sum of coefficients_precovid"
putexcel C1 = "p value (sum)_precovid"
putexcel D1 = "p value (joint)_precovid"
putexcel A2 = "l1.cf1 through l4.cf1"
putexcel A3 = "cf10 through l4.cf10" 
putexcel A4 = "gcpi through l4.gcpi"
putexcel A6 = "R2"
putexcel A7 = "number of observations"
putexcel A9 = "homogeneity constraint"

* Compute sum of coefficients 
gen aa3_`c' = _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] 
gen bb3_`c' = _b[cf10_`c'] + _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c']
gen cc3_`c' = _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  

putexcel B2 = aa3_`c'
putexcel B3 = bb3_`c'
putexcel B4 = cc3_`c'


* P-value (sum)
test _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 0
matrix b = r(p)'
putexcel C2 = matrix(b), nformat(number_d7)

test _b[cf10_`c'] + _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] = 0 
matrix b = r(p)'
putexcel C3 = matrix(b), nformat(number_d7) 

test _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  = 0
matrix b = r(p)'
putexcel C4 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c'  
matrix b = r(p)'
putexcel D2 = matrix(b), nformat(number_d7)  

test cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' 
matrix b = r(p)'
putexcel D3 = matrix(b), nformat(number_d7) 
   
test gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c'
matrix b = r(p)'
putexcel D4 = matrix(b), nformat(number_d7)    


* R-square and number of observations
corr cf1_`c' cf1f_`c' if period>=tq(1990:1)
gen r2cc_`c' = r(rho)^2
putexcel B6 = r2cc_`c'

gen n_obscc_`c' = e(N)
putexcel B7 = n_obscc_`c'


*** unconstrained with homogeneity test 
reg cf1_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c''),tq(2019:4)), noconstant

test  _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] + _b[cf10_`c'] + _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] + _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] = 1

matrix b = r(p)'
putexcel B9 = matrix(b), nformat(number_d7)   

	}



***************************************************************************************************
* one year inflation expectation, constrained, full sample 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


*** USA, ECB, BOE, FRA, GER, ITA, ESP, BEL, NLD, CAN

local teams "USA ECB BOE FRA GER ITA ESP BEL NLD CAN"
local startperiod_USA 1989:1
local startperiod_ECB 1989:1
local startperiod_BOE 1990:1
local startperiod_FRA 1989:1
local startperiod_GER 1996:1
local startperiod_ITA 1999:2
local startperiod_ESP 1995:1
local startperiod_BEL 1996:1
local startperiod_NLD 1989:1
local startperiod_CAN 1994:1

foreach c of local teams{
	
constraint define 3  l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' + cf10_`c' + l1.cf10_`c' + l2.cf10_`c' + l3.cf10_`c' + l4.cf10_`c' + gcpi_`c' + l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' = 1

cnsreg cf1_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2)), c(3) noconstant

eststo col3
predict cf1f_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2))
gen cf1_residuals_`c' = cf1_`c'-cf1f_`c'

* Save coefficients in excel format 
putexcel set "(3) cf1_eq_coeff", modify sheet("cf1_`c'")
putexcel D1 = "beta_full"
putexcel D1 = "beta_full"
matrix b = e(b)'
putexcel C2 = matrix(b), rownames nformat(number_d7)


* Save summary stats in excel format 
putexcel set "(3) cf1_summary_stats", modify sheet("cf1_`c'")
putexcel G1 = "sum of coefficients_full"
putexcel G1 = "sum of coefficients_full"
putexcel H1 = "p value (sum)_full"
putexcel I1 = "p value (joint)_full"
putexcel F2 = "l1.cf1 through l4.cf1"
putexcel F3 = "cf10 through l4.cf10" 
putexcel F4 = "gcpi through l4.gcpi"
putexcel F6 = "R2"
putexcel F7 = "number of observations"
putexcel F9 = "homogeneity constraint"


* Compute sum of coefficients 
gen aa3_`c' = _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] 
gen bb3_`c' = _b[cf10_`c'] + _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c']
gen cc3_`c' = _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  

putexcel G2 = aa3_`c'
putexcel G3 = bb3_`c'
putexcel G4 = cc3_`c'


* P-value (sum)
test _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] = 0
matrix b = r(p)'
putexcel H2 = matrix(b), nformat(number_d7)

test _b[cf10_`c'] + _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] = 0 
matrix b = r(p)'
putexcel H3 = matrix(b), nformat(number_d7) 

test _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c']  = 0
matrix b = r(p)'
putexcel H4 = matrix(b), nformat(number_d7)

	   					   
* P-value(joint)
test l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c'  
matrix b = r(p)'
putexcel I2 = matrix(b), nformat(number_d7)  

test cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' 
matrix b = r(p)'
putexcel I3 = matrix(b), nformat(number_d7) 
   
test gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c'
matrix b = r(p)'
putexcel I4 = matrix(b), nformat(number_d7)    


* R-square and number of observations
corr cf1_`c' cf1f_`c' if period>=tq(1990:1)
gen r2cc_`c' = r(rho)^2
putexcel G6 = r2cc_`c'

gen n_obscc_`c' = e(N)
putexcel G7 = n_obscc_`c'

*** unconstrained with homogeneity test 
reg cf1_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c''),tq(2023:2)), noconstant

test  _b[l1.cf1_`c'] + _b[l2.cf1_`c'] + _b[l3.cf1_`c'] + _b[l4.cf1_`c'] + _b[cf10_`c'] + _b[l1.cf10_`c'] + _b[l2.cf10_`c'] + _b[l3.cf10_`c'] + _b[l4.cf10_`c'] + _b[gcpi_`c'] + _b[l1.gcpi_`c'] + _b[l2.gcpi_`c'] + _b[l3.gcpi_`c'] + _b[l4.gcpi_`c'] = 1

matrix b = r(p)'
putexcel G9 = matrix(b), nformat(number_d7)   

}

